var vicLastActedUnit;

function vicAfterPerform(args)
{
    var source = args.source_unit;
vicLastActedUnit = source;
    var target = args.target_unit;
    var targetTile = args.target_tile;
    var skill = args.skill;
    var success = args.success; 
if (vicDictionaryHasKey(skill.AllFlags, "move_self")) vicAfterMove(args);

if (success)
{
vicReplaceEffectsOnFlag(skill, target, targetTile, "replace_effects");
vicReplaceTileOccupantsEffectsOnFlag(skill, targetTile, "replace_occupants_effects");
}
else
{
vicApplyMultipleEffectsOnFlag(skill, target, targetTile, "effects_on_failure"); 
vicApplyMultipleEffectsOnFlag(skill, source, null, "self_effects_on_failure", false); // for effects that occur only on the source on failure
vicApplyMultipleEffectsOnFlag(skill, null, source.Tile, "self_tile_effects_on_failure"); // effects on the source tile and occupants on failure
}
}

// called upon use of movement skill
function vicAfterMove(args)
{
    var source = args.source_unit;
    var target = args.target_unit;
    var targetTile = args.target_tile;
//     var skill = args.skill;
    var success = args.success; 
if (success)
{
// vicEffectsOnMovement(source, source.Tile, "effects_on_exit");
vicEffectsOnMovement(source, targetTile, "effects_on_entry");
vicRemoveEffectsOnMovement(source, targetTile, "remove_effects_on_entry");
}
}

// applies unit effects when the supplied tile has tile effects with the specified flag
function vicEffectsOnMovement(unit, tile, flag)
{
if (unit == null || tile == null || flag == null) return null;

for (var i=0; i<tile.Effects.length; i++)
{
var effect = tile.Effects[i];
var line = effect.ScriptFlags.get(flag);
// this unit will be affected by this effect if it is either not flying or if it is flying and there is no not_affect_flying flag
if (line != null && (vicIsFlying(unit) == false || vicDictionaryHasKey(effect.AllFlags, "not_affect_flying") == false))
{
var effects = line.split(", ");
vicApplyMultipleEffects(effects, unit);
}
}
}

// removes unit effects from the unit when the supplied tile has tile effects with the specified flag
function vicRemoveEffectsOnMovement(unit, tile, flag)
{
if (unit == null || tile == null || flag == null) return null;

for (var i=0; i<tile.Effects.length; i++)
{
var effect = tile.Effects[i];
var line = effect.ScriptFlags.get(flag);
if (line != null && (vicIsFlying(unit) == false || vicDictionaryHasKey(effect.AllFlags, "not_affect_flying") == false))
{
var effects = line.split(", ");
vicRemoveMultipleEffects(effects, unit);
}
}
}

